/****** Object:  StoredProcedure [dbo].[P_EST_PED_ELTR_DEMANDA_CP_IT]    Script Date: 07/11/2013 13:59:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_REPLICA_NCM_CADASTRO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_REPLICA_NCM_CADASTRO]
GO

CREATE PROCEDURE [dbo].[P_EST_PROD_REPLICA_NCM_CADASTRO] (@NR_NCM_UNICO VARCHAR(100) = NULL) AS
BEGIN

	SET NOCOUNT ON; 
	DECLARE @NR_NCM VARCHAR(30)
	DECLARE @PIS_COFINS INT
	DECLARE @TIPO_TRIBUTACAO_PIS_COFINS INT
	DECLARE @TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA INT
	DECLARE @PERC_ALIQ MONEY
	DECLARE @PERC_ALIQ_IMPORTADO MONEY
	DECLARE @FLAG_CONS_TRIB_GRUPO INT
	SET @FLAG_CONS_TRIB_GRUPO = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE = 'FLAG_CONS_TRIB_GRUPO'),0);
	DECLARE cNcm CURSOR FAST_FORWARD READ_ONLY FOR 
	select
		distinct EST_PROD_NCM_CADASTRO.NR_NCM,
		EST_PROD_NCM_CADASTRO.PIS_COFINS,
		EST_PROD_NCM_CADASTRO.TIPO_TRIBUTACAO_PIS_COFINS,
		EST_PROD_NCM_CADASTRO.TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA,
		ISNULL(EST_PROD_NCM_CADASTRO.PERC_ALIQ,0) AS PERC_ALIQ,
		ISNULL(EST_PROD_NCM_CADASTRO.PERC_ALIQ_IMPORTADO,0) AS PERC_ALIQ_IMPORTADO
	from
		est_prod inner join EST_PROD_NCM_CADASTRO on
		est_prod.NR_NCM = EST_PROD_NCM_CADASTRO.NR_NCM
	WHERE  EST_PROD_NCM_CADASTRO.NR_NCM = ISNULL(@NR_NCM_UNICO,EST_PROD_NCM_CADASTRO.NR_NCM)
	OPEN cNcm
	FETCH NEXT FROM cNcm INTO @NR_NCM,@PIS_COFINS, 
							  @TIPO_TRIBUTACAO_PIS_COFINS,
							  @TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA,
							  @PERC_ALIQ,
							  @PERC_ALIQ_IMPORTADO
		WHILE @@FETCH_STATUS=0
		BEGIN
			begin
				Print 'Atualizando o NCM  ' + @NR_NCM
				update
					EST_PROD
				SET
					PIS_COFINS = @PIS_COFINS,
					TIPO_TRIBUTACAO_PIS_COFINS=@TIPO_TRIBUTACAO_PIS_COFINS,
					TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA=@TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA
				WHERE
					NR_NCM = @NR_NCM
					AND CD_EMP=1
					AND FLAG_EXCECAO_PIS_COFINS=0
			end					
		FETCH NEXT FROM cNcm INTO @NR_NCM,@PIS_COFINS, 
								  @TIPO_TRIBUTACAO_PIS_COFINS,
								  @TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA,
								  @PERC_ALIQ,
								  @PERC_ALIQ_IMPORTADO
		END
	CLOSE cNcm
	DEALLOCATE cNcm
END